.intel_syntax noprefix

.data

    error_string: .asciz "Nepoznata operacija! Zavrsavam program...\n"

.text

    .global evaluate

evaluate:
    enter 0, 0
    
    cmp dl, '+'
    je add
    
    cmp dl, '-'
    je subtract
    
    cmp dl, '*'
    je multiply
    
    cmp dl, '/'
    je divide_quotient
    
    cmp dl, '%'
    je divide_remainder
    
    mov rdi, stderr
    lea rsi, error_string
    mov rax, 0
    call fprintf
    
    mov edi, 1
    call exit

end:   
    leave
    ret

add:
    add edi, esi
    mov eax, edi
    jmp end

subtract:
    sub edi, esi
    mov eax, edi
    jmp end

multiply:
    mov eax, edi
    imul esi
    jmp end

divide_quotient:
    mov eax, edi
    cdq
    idiv esi
    jmp end

divide_remainder:
    mov eax, edi
    cdq
    idiv esi
    mov eax, edx
    jmp end

